<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

function explm_licence_tab_content()
{       

    if (isset($_POST['explm_settings_nonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['explm_settings_nonce'])), 'explm_save_settings')) {
        $email = isset($_POST['explm_email']) ? sanitize_email(wp_unslash($_POST['explm_email'])) : '';
        $licence_key = isset($_POST['explm_licence_key']) ? sanitize_text_field(wp_unslash($_POST['explm_licence_key'])) : '';
        $country = isset($_POST['explm_country']) ? sanitize_text_field(wp_unslash($_POST['explm_country'])) : '';

        if (!empty($email)) {
            update_option('explm_email_option', $email);
            if (!empty($licence_key)) {
                update_option('explm_licence_option', $licence_key);
            }
            if (!empty($country)) {
                update_option('explm_country_option', $country);
            }
            echo '<div class="updated"><p>' . esc_html__('Settings saved.', 'express-label-maker') . '</p></div>';
        } else {
            echo '<div class="error"><p>' . esc_html__('Email is required.', 'express-label-maker') . '</p></div>';
        }
    }
    
    $saved_email = get_option('explm_email_option', '');
    $saved_licence_key = get_option('explm_licence_option', '');
    $saved_country = get_option('explm_country_option', '');

    echo '<div style="display:flex;flex-wrap:wrap;">';
    echo '<div>';
    echo '<form method="post" action="">';
    echo '<table class="form-table">';
    echo '<tr>';
    echo '<th scope="row"><label for="explm_email">' . esc_html__('Email*', 'express-label-maker') . '</label></th>';
    echo '<td><input name="explm_email" type="email" id="explm_email" value="' . esc_attr($saved_email) . '" class="regular-text" required></td>';
    echo '</tr>';
    echo '<tr>';
    echo '<th scope="row"><label for="explm_licence_key">' . esc_html__('API key*', 'express-label-maker') . '</label></th>';
    echo '<td><input name="explm_licence_key" type="text" id="explm_licence_key" value="' . esc_attr($saved_licence_key) . '" class="regular-text" placeholder="' . esc_html__('Your API key or click Start Trial', 'express-label-maker') . '">';
    echo '<button id="start-trial-btn" class="button explm-start-trial-btn" style="display:none;margin-left:15px;">' . esc_html__('Start Trial', 'express-label-maker') . '</button></td>';
    echo '</tr>';
    echo '<tr>';
    echo '<th scope="row"><label for="explm_country">' . esc_html__('Country*', 'express-label-maker') . '</label></th>';
    echo '<td>';
    echo '<select name="explm_country" id="explm_country">';
    echo '<option value="hr"' . selected($saved_country, 'hr', true) . '>' . esc_html__('Croatia', 'express-label-maker') . '</option>';
    echo '<option value="si"' . selected($saved_country, 'si', false) . '>' . esc_html__('Slovenia', 'express-label-maker') . '</option>';
    echo '</select>'; 
    echo '</td>';
    echo '</tr>';
    echo '</table>';
    echo '<p class="submit">';
    echo '<input type="submit" name="submit" id="explm_submit_btn" class="button button-primary" value="' . esc_html__('Save Changes', 'express-label-maker') . '">';
    echo '</p>';
    wp_nonce_field('explm_save_settings', 'explm_settings_nonce');
    echo '</form>';

    echo '<div style="margin-top: 50px;">';
    echo '<table class="form-table">';
    echo '<h3>' . esc_html__('Connection status', 'express-label-maker') . '</h3>';
    echo '<tr>';
    echo '<th scope="row" style="width: 100px;"><label>' . esc_html__('Valid from', 'express-label-maker') . '</label></th>';
    echo '<td><input type="text" readonly value="" class="regular-text explm-licence-inputs" id="explm_valid_from"></td>';
    echo '<th scope="row" style="padding-left: 2%;width: 100px;"><label>' . esc_html__('Label limit', 'express-label-maker') . '</label></th>';
    echo '<td><input type="text" readonly value="" class="regular-text explm-licence-inputs" id="explm_usage_limit"></td>';
    echo '</tr>';
    echo '<tr>';
    echo '<th scope="row" style="width: 100px;"><label>' . esc_html__('Valid to', 'express-label-maker') . '</label></th>';
    echo '<td><input type="text" readonly value="" class="regular-text explm-licence-inputs" id="explm_valid_until"></td>';
    echo '<th scope="row" style="padding-left: 2%;width: 100px;"><label>' . esc_html__('Used', 'express-label-maker') . '</label></th>';
    echo '<td><input type="text" readonly value="" class="regular-text explm-licence-inputs" id="explm_usage"></td>';
    echo '</tr>';
    echo '</table>';
    echo '</div>';

    $plugin_version = ExplmLabelMaker::get_plugin_version();

    echo '<div style="margin-top:20px;"> v' . esc_html( $plugin_version ) . '</div>';
    echo '</div>';

    $payment_url = EXPLM_API_BASE_URL . 'hr/payment/' . ( $saved_licence_key ? rawurlencode( $saved_licence_key ) : '' );

    echo '<div class="explm-licence-side">';
    echo '  <div class="explm-licence-payment">';
    echo '    <h3>' . esc_html__( 'Manage account', 'express-label-maker' ) . '</h3>';
    echo '    <p>' . esc_html__( 'Use your ExpressLabelMaker.com account to connect this plugin and manage your API key.', 'express-label-maker' ) . '</p>';
    echo '    <a class="button button-primary" target="_blank" rel="noopener" href="' . esc_url( $payment_url ) . '">'
            . esc_html__( 'Open account', 'express-label-maker' ) .
        '</a>';

    // --- Documentation links (HR/EN) ---
    $locale   = function_exists('determine_locale') ? determine_locale() : get_locale();
    $lang_key = (strpos($locale, 'hr') === 0) ? 'hr' : 'en';

    $install_url = ($lang_key === 'hr')
    ? 'https://expresslabelmaker.com/hr/documentation/instalacija'
    : 'https://expresslabelmaker.com/en/documentation/installation';

    $docs = [
        'gls' => [
            'label' => __( 'GLS documentation', 'express-label-maker' ),
            'hr'    => 'https://expresslabelmaker.com/hr/documentation/koristenje-gls',
            'en'    => 'https://expresslabelmaker.com/en/documentation/usage-gls',
        ],
        'dpd' => [
            'label' => __( 'DPD documentation', 'express-label-maker' ),
            'hr'    => 'https://expresslabelmaker.com/hr/documentation/koristenje-dpd',
            'en'    => 'https://expresslabelmaker.com/en/documentation/usage-dpd',
        ],
        'overseas' => [
            'label' => __( 'Overseas Express documentation', 'express-label-maker' ),
            'hr'    => 'https://expresslabelmaker.com/hr/documentation/koristenje-overseas-express',
            'en'    => 'https://expresslabelmaker.com/en/documentation/usage-overseas-express',
        ],
        'hp' => [
            'label' => __( 'Croatian Post documentation', 'express-label-maker' ),
            'hr'    => 'https://expresslabelmaker.com/hr/documentation/koristenje-hrvatska-posta',
            'en'    => 'https://expresslabelmaker.com/en/documentation/usage-croatian-post',
        ],
    ];

    echo '    <hr style="margin:14px 0;">';

    // --- Highlighted install/licence activation ---
    echo '    <div style="border:1px solid #dcdcde; border-left:4px solid #2271b1; background:#fff; padding:12px; border-radius:6px; margin-bottom:12px;">';
    echo '      <div style="display:flex; align-items:center; justify-content:space-between; gap:10px; flex-wrap:wrap;">';
    echo '        <strong style="font-size:14px;">' . esc_html__( 'Installation & Account Connection', 'express-label-maker' ) . '</strong>';
    echo '        <span style="font-size:11px; padding:2px 8px; border-radius:999px; background:#2271b1; color:#fff;">' . esc_html__( 'Start here', 'express-label-maker' ) . '</span>';
    echo '      </div>';
    echo '      <p style="margin:8px 0 10px; color:#50575e;">' . esc_html__( 'Follow the steps for plugin installation and connecting your account so you can start generating labels.', 'express-label-maker' ) . '</p>';
    echo '      <a class="button button-secondary" target="_blank" rel="noopener" href="' . esc_url( $install_url ) . '">'
                . esc_html__( 'Open installation guide', 'express-label-maker' ) .
            '</a>';
    echo '    </div>';

    // --- Other docs list ---
    echo '    <h4 style="margin:0 0 8px;">' . esc_html__( 'Carrier documentation', 'express-label-maker' ) . '</h4>';
    echo '    <ul style="margin:0; padding-left:18px;">';
    foreach ($docs as $item) {
    $url = $item[$lang_key] ?? $item['hr'];
    echo '      <li><a target="_blank" rel="noopener" href="' . esc_url($url) . '">' . esc_html($item['label']) . '</a></li>';
    }
    echo '    </ul>';

    echo '  </div>';
    echo '</div>';
}